<?php 
/*
// "K2 User" Plugin by JoomlaWorks for Joomla! 1.5.x - Version 2.1
// Copyright (c) 2006 - 2009 JoomlaWorks Ltd. All rights reserved.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr and http://k2.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// *** Last update: September 9th, 2009 ***
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

class plgUserK2 extends JPlugin {

  function plgUserK2(&$subject, $config) {
  
    parent::__construct($subject, $config);
  }
  
  function onAfterStoreUser($user, $isnew, $success, $msg) {
  
    global $mainframe;
    $params = &JComponentHelper::getParams('com_k2');
    jimport('joomla.filesystem.file');
    if ($mainframe->isAdmin()) {
      return;
    }
    
    $task = JRequest::getCmd('task');
    if ($task == 'activate') {
      return;
    }
    
    if (!JRequest::getInt('K2UserForm'))
      return;
      
    if ($isnew) {
      $plugin = &JPluginHelper::getPlugin('user', 'k2');
      $pluginParams = new JParameter($plugin->params);
      $group = $pluginParams->get('K2UserGroup', 1);
      
      JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'tables');
      $row = &JTable::getInstance('K2User', 'Table');
      
      $row->bind(JRequest::get('post'));
      
      $row->set('userID', $user['id']);
      $row->set('userName', $user['name']);
      $row->set('group', $group);
      
      $row->set('gender', JRequest::getVar('gender'));
      $row->set('url', JRequest::getVar('url'));
      $row->set('description', JRequest::getVar('description', '', 'post', 'string', JREQUEST_ALLOWRAW));
      
      $file = JRequest::get('files');
      
      require_once (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'lib'.DS.'class.upload.php');
      $savepath = JPATH_ROOT.DS.'media'.DS.'k2'.DS.'users'.DS;
      
      if ($file['image']['error'] == 0 && !JRequest::getBool('del_image')) {
        $handle = new Upload($file['image']);
        $handle->allowed = array('image/*');
        if ($handle->uploaded) {
          $handle->file_auto_rename = false;
          $handle->file_overwrite = true;
          $handle->file_new_name_body = $row->id;
          $handle->image_resize = true;
          $handle->image_ratio_y = true;
          $handle->image_x = $params->get('userImageWidth', '100');
          $handle->Process($savepath);
          $handle->Clean();
        } else {
          $mainframe->enqueueMessage(JText::_('Could not upload your image.').$handle->error, 'notice');
        }
        $row->image = $handle->file_dst_name;
      }
      $row->store();
      
    } else {
      JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'tables');
      $row = &JTable::getInstance('K2User', 'Table');
      $k2id = $this->getK2UserID($user['id']);
      JRequest::setVar('id', $k2id, 'post');
      $row->bind(JRequest::get('post'));
      $row->set('gender', JRequest::getVar('gender'));
      $row->set('url', JRequest::getVar('url'));
      $row->set('description', JRequest::getVar('description', '', 'post', 'string', JREQUEST_ALLOWRAW));
      
      $file = JRequest::get('files');
      
      require_once (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'lib'.DS.'class.upload.php');
      $savepath = JPATH_ROOT.DS.'media'.DS.'k2'.DS.'users'.DS;
      
      if ($file['image']['error'] == 0 && !JRequest::getBool('del_image')) {
        $handle = new Upload($file['image']);
        if ($handle->uploaded) {
          $handle->file_auto_rename = false;
          $handle->file_overwrite = true;
          $handle->file_new_name_body = $row->id;
          $handle->image_resize = true;
          $handle->image_ratio_y = true;
          $handle->image_x = $params->get('userImageWidth', '100');
          $handle->Process($savepath);
          $handle->Clean();
        } else {
          $mainframe->enqueueMessage(JText::_('Could not upload your image.').$handle->error, 'warning');
        }
        $row->image = $handle->file_dst_name;
      }
      
      if (JRequest::getBool('del_image')) {
      
        $current = &JTable::getInstance('K2User', 'Table');
        $current->load($row->id);
        if (JFile::exists(JPATH_ROOT.DS.'media'.DS.'k2'.DS.'users'.DS.$current->image)) {
          JFile::delete(JPATH_ROOT.DS.'media'.DS.'k2'.DS.'users'.DS.$current->image);
        }
        $row->image = '';
      }
      
      $row->store();
      
    }
    
  }
  
  function onAfterDeleteUser($user, $succes, $msg) {
  
    global $mainframe;
    $db = &JFactory::getDBO();
    $query = "DELETE FROM #__k2_users WHERE userID={$user['id']} LIMIT 1";
    $db->setQuery($query);
    $db->query();
  }
  
  function getK2UserID($id) {
  
    $db = &JFactory::getDBO();
    $query = "SELECT id FROM #__k2_users WHERE userID={$id}";
    $db->setQuery($query);
    $result = $db->loadResult();
    return $result;
  }
  
}
