<?php 
/*
// "K2 Search" Plugin by JoomlaWorks for Joomla! 1.5.x - Version 2.1
// Copyright (c) 2006 - 2009 JoomlaWorks Ltd. All rights reserved.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr and http://k2.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// *** Last update: September 9th, 2009 ***
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

$mainframe->registerEvent('onSearch', 'plgSearchItems');
$mainframe->registerEvent('onSearchAreas', 'plgSearchItemsAreas');

JPlugin::loadLanguage('plg_search_k2');

function & plgSearchItemsAreas() {
  static $areas = array('k2'=>'K2 Items');
  return $areas;
}

function plgSearchItems($text, $phrase = '', $ordering = '', $areas = null) {

  global $mainframe;
  
  $db = &JFactory::getDBO();
  $user = &JFactory::getUser();
  $aid = $user->get('aid');
  
  require_once (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_search'.DS.'helpers'.DS.'search.php');
  require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
  
  $searchText = $text;
  if (is_array($areas)) {
    if (!array_intersect($areas, array_keys(plgSearchItemsAreas()))) {
      return array();
    }
  }
  
  $plugin = &JPluginHelper::getPlugin('search', 'k2');
  $pluginParams = new JParameter($plugin->params);
  
  $limit = $pluginParams->def('search_limit', 50);
  
  $text = trim($text);
  if ($text == '') {
    return array();
  }
  
  $wheres = array();
  switch ($phrase) {
    case 'exact':
      $text = $db->Quote('%'.$db->getEscaped($text, true).'%', false);
      $wheres2 = array();
      $wheres2[] = 'i.title LIKE '.$text;
      $wheres2[] = 'i.introtext LIKE '.$text;
      $wheres2[] = 'i.fulltext LIKE '.$text;
      $wheres2[] = 'tags.name LIKE '.$text;
      $wheres2[] = 'i.image_caption LIKE '.$text;
      $wheres2[] = 'i.image_credits LIKE '.$text;
      $wheres2[] = 'i.video_caption LIKE '.$text;
      $wheres2[] = 'i.video_credits LIKE '.$text;
      $wheres2[] = 'i.extra_fields_search LIKE '.$text;
      $wheres2[] = 'i.metadesc LIKE '.$text;
      $wheres2[] = 'i.metakey LIKE '.$text;
      $where = '('.implode(') OR (', $wheres2).')';
      break;
      
    case 'all':
    case 'any':
    default:
      $words = explode(' ', $text);
      $wheres = array();
      foreach ($words as $word) {
        $word = $db->Quote('%'.$db->getEscaped($word, true).'%', false);
        $wheres2 = array();
        $wheres2[] = 'i.title LIKE '.$word;
        $wheres2[] = 'i.introtext LIKE '.$word;
        $wheres2[] = 'i.fulltext LIKE '.$word;
        $wheres2[] = 'tags.name LIKE '.$word;
        $wheres2[] = 'i.image_caption LIKE '.$word;
        $wheres2[] = 'i.image_credits LIKE '.$word;
        $wheres2[] = 'i.video_caption LIKE '.$word;
        $wheres2[] = 'i.video_credits LIKE '.$word;
        $wheres2[] = 'i.extra_fields_search LIKE '.$word;
        $wheres2[] = 'i.metadesc LIKE '.$word;
        $wheres2[] = 'i.metakey LIKE '.$word;
        $wheres[] = implode(' OR ', $wheres2);
      }
      $where = '('.implode(($phrase == 'all' ? ') AND (' : ') OR ('), $wheres).')';
      break;
  }
  
  switch ($ordering) {
    case 'oldest':
      $order = 'i.created ASC';
      break;
      
    case 'popular':
      $order = 'i.hits DESC';
      break;
      
    case 'alpha':
      $order = 'i.title ASC';
      break;
      
    case 'category':
      $order = 'c.name ASC, i.title ASC';
      $morder = 'i.title ASC';
      break;
      
    case 'newest':
    default:
      $order = 'i.created DESC';
      break;
  }
  
  $rows = array();
  
  if ($limit > 0) {
  
    $query = 'SELECT i.title AS title, i.metadesc, i.metakey, c.name as section, i.image_caption, i.image_credits, i.video_caption, i.video_credits, i.extra_fields_search, tags.name as tag,'.' i.created,'.' CONCAT(i.introtext, i.fulltext) AS text,'.' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(":", i.id, i.alias) ELSE i.id END as slug,'.' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(":", c.id, c.alias) ELSE c.id END as catslug'.' FROM #__k2_items AS i'.' INNER JOIN #__k2_categories AS c ON c.id=i.catid AND c.access <= '.$user->get('gid').' LEFT JOIN #__k2_tags_xref tags_xref ON tags_xref.itemID = i.id LEFT JOIN #__k2_tags tags ON tags.id = tags_xref.tagID'.' WHERE ( '.$where.' )'.' AND i.trash = 0'.' AND i.published = 1'.' AND c.published = 1'.' AND i.access <= '.$aid.' AND c.access <= '.$aid.' GROUP BY i.id'.' ORDER BY '.$order;
    
    $db->setQuery($query, 0, $limit);
    $list = $db->loadObjectList();
    
    $limit -= count($list);
    
    if (isset($list)) {
      foreach ($list as $key=>$item) {
        $list[$key]->href = JRoute::_(K2HelperRoute::getItemRoute($item->slug, $item->catslug));
        
      }
    }
    $rows[] = $list;
  }
  
  $results = array();
  if (count($rows)) {
    foreach ($rows as $row) {
      $new_row = array();
      foreach ($row as $key=>$item) {
        $item->browsernav = '';
        if (searchHelper::checkNoHTML($item, $searchText, array('text', 'title', 'metakey', 'metadesc', 'section', 'tag', 'image_caption', 'image_credits', 'video_caption', 'video_credits', 'extra_fields_search'))) {
          $new_row[] = $item;
        }
      }
      $results = array_merge($results, (array) $new_row);
    }
  }
  
  return $results;
}
