<?php
/*
// "K2" Component by JoomlaWorks for Joomla! 1.5.x - Version 2.0
// Copyright (c) 2006 - 2009 JoomlaWorks Ltd. All rights reserved.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr and http://k2.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// *** Last update: August 6th, 2009 ***
*/

// no direct access
defined('_JEXEC') or die ('Restricted access');

jimport('joomla.application.component.helper');

class K2HelperRoute
{

	function getItemRoute($id, $catid = 0) {
	
		$needles = array (
		'item'=>(int)$id,
		'itemlist'=>(int)$catid,
		);
		$link = 'index.php?option=com_k2&view=item&id='.$id;
	
		if ($item = K2HelperRoute::_findItem($needles)) {
			$link .= '&Itemid='.$item->id;
		}
		return $link;
	}

	function getCategoryRoute($catid)	{
	
		$needles = array (
		'itemlist'=>(int)$catid
		);
	
		$link = 'index.php?option=com_k2&view=itemlist&task=category&id='.$catid;
		
		if ($item = K2HelperRoute::_findItem($needles)) {
			$link .= '&Itemid='.$item->id;
		}
		return $link;
	}
	
	function getUserRoute($userID) {
	
		$needles = array (
		'user'=>(int)$userID
		);
	
		$link = 'index.php?option=com_k2&view=itemlist&task=user&id='.$userID;
	
		if ($item = K2HelperRoute::_findItem($needles)) {
			$link .= '&Itemid='.$item->id;
		}
		;
	
		return $link;
	}
	
	function getTagRoute($tag) {
	
		$needles = array (
		'tag'=>$tag
		);
	
		$link = 'index.php?option=com_k2&view=itemlist&task=tag&tag='.urlencode($tag);
	
		if ($item = K2HelperRoute::_findItem($needles)) {
			$link .= '&Itemid='.$item->id;
		}
		;
	
		return $link;
	}

	function _findItem($needles)	{
	
		$component = & JComponentHelper::getComponent('com_k2');
	
		$menus = & JApplication::getMenu('site', array ());
		$items = $menus->getItems('componentid', $component->id);
	
		$match = null;
	
		foreach ($needles as $needle=>$id)
		{
			if (count($items)){
				foreach ($items as $item)
				{	
					if ($needle=='user'){
						if ((@$item->query['task'] == $needle) && (@$item->query['id'] == $id)) {
							$match = $item;
							break;
						}					
						
					}
					else if ($needle=='tag'){
						if ((@$item->query['task'] == $needle) && (@$item->query['tag'] == $id)) {
							$match = $item;
							break;
						}		
					}
					else {

						if ((@$item->query['view'] == $needle) && (@$item->query['id'] == $id)) {
							$match = $item;
							break;
						}
						
						$menuparams = new JParameter( $item->params );
						$catids=$menuparams->get('categories');
						
						if(is_array($catids)){
							foreach ($catids as $catid)	{
								if ((@$item->query['view'] == $needle) && (@(int)$catid == $id)){
									$match = $item;
									break;
								}						
							}
						}
						/*else{
							
							if ( (@$item->query['view'] == $needle) && (!isset($item->query['task'])) && (@$item->query['view'] == 'itemlist') ) {
								$match = $item;
							}
							
						}*/

					}
	
				}
			}
		
			if ( isset ($match)) {
				break;
			}
		}
	
		return $match;
	}

}
